#ifndef _Command_CPP
#define _Command_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/LZARICode.H"

#include "../../SharedClasses/CRC32/CRC.H"

#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../../SharedClasses/SQLClass/cSQL.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLExport.H"
#include "Console.H"
#include "DBInit.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConnectToServer(bool bForcedConnect)
{
	char IPAddress[64];
	char sSQL[1024];
	CRecordSet rsTemp;
	
	if(gServer.bcConnected[CCI.iThisClient])
	{
		WriteSysLog("Already connected.");
		return false;
	}

	if(!GetIPAddress(gsServerAddress, IPAddress))
    {
        WriteSysLog("Error resolving hostname.");
        return false;
    }

	if(CCI.cCustSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		WriteSysLog("Successfully connected to the database.");
		CCI.bCustDBConnected = true;
	}
	else{
		WriteSysLog("Failed to connect to the database.");
		return false;						
	}

	if(!bForcedConnect)
	{
		sprintf(sSQL, "SELECT TransTable"
			" FROM [%s].[%s].SQLExch_Trans"
			" WHERE TransDB = '%s'",
			gsReplicationDB, gsDefaultDBO,
			gsSQLDatabase);

		if(!CCI.cCustSQL.Execute(sSQL, &rsTemp))
		{
			WriteSysLog("Failed to get the transaction count.");
			rsTemp.Close();
			CCI.cCustSQL.Disconnect();
			return false;
		}

		if(rsTemp.RowCount <= 0)
		{
			WriteSysLog("No new transactions are available, no need to connect.");
			rsTemp.Close();
			CCI.cCustSQL.Disconnect();
			return true;
		}
	}

	if(gServer.DoConnect(IPAddress, giServerPort, &CCI.iThisClient))
	{
		WriteLog(gServer.icClientID[CCI.iThisClient], "Connected successfully.");
	}
	else{
		WriteSysLog("Failed to connect.");

		if(gServer.bcConnected[CCI.iThisClient])
		{
			WriteLog(gServer.icClientID[CCI.iThisClient], "Dropping a possible locked connection.");
			gServer.bcDisconnect[CCI.iThisClient] = true;
		}

		CCI.cCustSQL.Disconnect();
		return false;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sRecvBuf, int iRecvBufSz);

	Processes a command from the peer.

	Possible return Values:
		CMD_OK    The command was a success, all is well.
		CMD_DONE  The command was a success, close the connection.
		CMD_ERROR The command failed due to an error.
*/
int ProcessCommand(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[IDEAL_RECV_SIZE + 1];
	char sTemp[1024];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::BeginInit")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Server is requesting that the replication be initialized.");

		char sTempFile[MAX_PATH];

		GetTempFileName(sTempFilesPath, "SEC", 0, sTempFile);

		if(GenerateDBCreationSQL(&CCI.cCustSQL, pSockSrvr, iClient, "DB Unused", "DBO Unused", sTempFile))
		{
			pSockSrvr->SetNextSendData(iClient, "::SendingDBCreationSQL");
			SendFileData(pSockSrvr, iClient, sTempFile);
		}

		DeleteFile(sTempFile);

		//MsgBox("BeginInit!");
		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::BeginReplication->")))
    {
		if(gbDebugMode)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Received the begin transaction.");
		}

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		if( strcmpi(sCmdData, "Transactions") == 0)
		{
			//Need to set the "SQLExch_Trans.SQLExch_Pending" flag to 1
			//	so that we dont delete any new transaction when we clear
			//	the table after the replication process.
			sprintf(sTemp, "UPDATE [%s].[%s].SQLExch_Trans"
				" SET SQLExch_Pending = 1"
				" WHERE TransDB = '%s'",
				gsReplicationDB, gsDefaultDBO,
				gsSQLDatabase);
			CCI.cCustSQL.ExecuteNonQuery(sTemp);

			//Get a list of all of the statements that need to be ran.
			sprintf(sTemp, "SELECT DISTINCT A.Statement, A.OnSuccess, A.OnFailure, A.ImportTable, A.[Sequence]"
				" FROM [%s].[%s].SQLExch_Statements AS A, [%s].[%s].SQLExch_Trans AS B"
				" WHERE A.TransDB = '%s' AND B.TransDB = '%s'"
				" AND B.TransTable = A.TransTable"
				" AND A.Active = 1 AND B.SQLExch_Pending = 1"
				" ORDER BY A.[Sequence], A.Statement, A.OnSuccess, A.OnFailure, A.ImportTable",
				gsReplicationDB, gsDefaultDBO,
				gsReplicationDB, gsDefaultDBO,
				gsSQLDatabase, gsSQLDatabase);
		}
		else if( strcmpi(sCmdData, "All") == 0) {

			//Get a list of all of the statements that need to be ran.
			sprintf(sTemp, "SELECT DISTINCT 'SELECT * FROM [%s].[%s].[' + TransTable + ']', NULL, NULL, TransTable"
				" FROM [%s].[%s].SQLEXCH_Statements"
				" WHERE TransDB = '%s'",
				gsSQLDatabase, gsDefaultDBO,
				gsReplicationDB, gsDefaultDBO,
				gsSQLDatabase);
		}

		CCI.rsTrans.bReplaceSingleQuotes = false;
		if(!CCI.cCustSQL.Execute(sTemp, &CCI.rsTrans))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to get a list of transactions.");
			return CMD_ERROR;
		}

		sprintf(sTemp, "Processing %d replication statements.", CCI.rsTrans.RowCount);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		return ExecuteTransactionSQL(pSockSrvr, iClient);
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Compression->")))
    {
		if(gbDebugMode)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Received compression option.");
		}

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		if(strcmpi(sCmdData, "On") == 0)
		{
			CCI.bUseCompression = true;
		}
		else{
			CCI.bUseCompression = false;
		}

		return CMD_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Msg->")))
    {
		if(gbDebugMode)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Received a message from the server.");
		}

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sCmdData);
		return CMD_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::LastImportSuccess")))
    {
		//The last import succeeded. If we need to take action then this is where to do it.
		WriteLog(pSockSrvr->icClientID[iClient], "Last import was a Success.");

		bool bResult = false;

		if(strlen(CCI.sOnSuccess) > 0)
		{
			bResult = CCI.cCustSQL.ExecuteNonQuery(CCI.sOnSuccess);
			strcpy(CCI.sOnSuccess, "");
			if(!bResult)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to execute the OnSuccess statement.");
				return CMD_ERROR;
			}
		}

		return ExecuteTransactionSQL(pSockSrvr, iClient);
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::LastImportFailed")))
    {
		//The last import failed. If we need to take action then this is where to do it.

		bool bResult = false;

		WriteLog(pSockSrvr->icClientID[iClient], "Last import failed.");
		giWarningCount++;

		if(strlen(CCI.sOnFailure) > 0)
		{
			bResult = CCI.cCustSQL.ExecuteNonQuery(CCI.sOnFailure);
			strcpy(CCI.sOnFailure, "");
			if(!bResult)
			{
				WriteLog(pSockSrvr->icClientID[iClient], "Failed to execute the OnFailure statement.");
				return CMD_ERROR;
			}
		}

		if(ExecuteTransactionSQL(pSockSrvr, iClient))
		{
			return CMD_OK;
		}
		else{
			return CMD_ERROR;
		}

		return CMD_OK;
	}

	giWarningCount++;
	WriteLog(pSockSrvr->icClientID[iClient], "Received unknown command.");
	return CMD_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SendFileData(CSockSrvr *pSockSrvr, int iClient, char *sFileName)
{
    FILE *hSourceHandle = NULL;

	char sFullFile[MAX_PATH];
    char sFileBuffer[FILEBUFFERSZ + 1];
	int iBytesRead = 0;

    //DWORD dwDataCRC = 0xffffffff;

	if(CCI.bUseCompression)
	{
		float dwBeforeSz = (float) Get_FileSize(sFileName);
		float dwAfterSz = 0;

		sprintf(sFullFile, "%s.lza", sFileName);

		sprintf(sFileBuffer, "Compressing file. (%.2f KB)", dwBeforeSz / 1024);
		WriteLog(pSockSrvr->icClientID[iClient], sFileBuffer);
		
		CompressFile(sFileName, sFullFile);

		dwAfterSz = (float) Get_FileSize(sFullFile);

		sprintf(sFileBuffer, "File size reduced from %.2f KB to %.2f KB. (%.2f %% Compression).",
			dwBeforeSz / 1024, dwAfterSz / 1024, (100 - ((dwAfterSz / dwBeforeSz) * 100)));
		WriteLog(pSockSrvr->icClientID[iClient], sFileBuffer);
	}
	else{
		strcpy(sFullFile, sFileName);
	}

	WriteLog(pSockSrvr->icClientID[iClient], "Begining file transfer.");
	if( (hSourceHandle = fopen(sFullFile, "rb")) == NULL)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Failed to open export file for binary read.");
		giWarningCount++;
        return false;
    }

    do{
        //if(MyClient.PeekSizeOfSendData() == 0)
        //{
            iBytesRead = fread(sFileBuffer, sizeof(char), FILEBUFFERSZ, hSourceHandle);
            //dwDataCRC = PartialCRC(dwDataCRC, sFileBuffer, iBytesRead);
            CCI.cNASCCL.Encode(sFileBuffer, sFileBuffer, iBytesRead);
			pSockSrvr->SetNextSendDataEx(iClient, sFileBuffer, iBytesRead);
        //}
        //else Sleep(1);
    } while(iBytesRead == FILEBUFFERSZ && pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient]);

	fclose(hSourceHandle);

	DeleteFile(sFullFile);
	DeleteFile(sFileName);

	if(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
	{
		WriteLog(pSockSrvr->icClientID[iClient], "File Transfer complete.");
		pSockSrvr->SetNextSendData(iClient, "::EOF");
		
		//Send the data CRC.
		//sprintf(sFileBuffer, "%X", dwDataCRC);
		//pSockSrvr->SetNextSendData(iClient, sFileBuffer);
		return true;
	}
	else return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ExecuteTransactionSQL(CSockSrvr *pSockSrvr, int iClient)
{
	char sTempFile[MAX_PATH];
    char sSendBuf[IDEAL_SEND_SIZE + 1];
	int iSendBufSz = 0;
	long lFetchResult = 0;

	char sStatement[2048 + 1];
	char sImportTable[2048 + 1];
	int iSz = 0;

	if(gbDebugMode)
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Executing transaction SQL.");
	}

	while(CCI.rsTrans.FetchEx(&lFetchResult))
	{
		CCI.rsTrans.sColumnEx(1, sStatement, sizeof(sStatement), &iSz);
		if(iSz <= 0)
		{
			strcpy(sStatement, "");
		}

		CCI.rsTrans.sColumnEx(2, CCI.sOnSuccess, sizeof(CCI.sOnSuccess), &iSz);
		if(iSz <= 0)
		{
			strcpy(CCI.sOnSuccess, "");
		}

		CCI.rsTrans.sColumnEx(3, CCI.sOnFailure, sizeof(CCI.sOnFailure), &iSz);
		if(iSz <= 0)
		{
			strcpy(CCI.sOnFailure, "");
		}

		CCI.rsTrans.sColumnEx(4, sImportTable, sizeof(sImportTable), &iSz);
		if(iSz <= 0)
		{
			strcpy(sImportTable, "");
		}
		
		if(iSz > 0)
		{
			GetTempFileName(sTempFilesPath, "SEC", 0, sTempFile);

			int iSQLExpRes = ExportSQLResults(pSockSrvr, iClient, sStatement,
				gsSQLDatabase, gsDefaultDBO, sImportTable, sTempFile);

			if(iSQLExpRes == SQL_IMPORT_RESULT_ZEROROWS)
			{
				//The statement was supposed to return data, it didnt... Thats ok!
				//Process the next statement.
				DeleteFile(sTempFile);
				continue;
			}
			else if(iSQLExpRes == SQL_IMPORT_RESULT_OK){
				//sprintf(FlaggedData, "::FileSize:%d", Get_FileSize(gsSQLExportTempFile));
				//SimpleClientSend(FlaggedData);

				sprintf(sSendBuf, "::SendingFileData->%s", sImportTable);
				pSockSrvr->SetNextSendData(iClient, sSendBuf);

				SendFileData(pSockSrvr, iClient, sTempFile);
				return CMD_OK;
			}
			else if(iSQLExpRes == SQL_IMPORT_RESULT_ERROR){
				// There was an error exporting the SQL data.
				// FIXME: What do we do now, Process the next statement or disconnect?
				//		Need to think over the logic.
				DeleteFile(sTempFile);
				return CMD_ERROR;
			}
		}
		else{
			//The statement was not a statement that is supposed to return data.
			//Process the next statement.

			CRecordSet rsTemp;

			if(!CCI.cCustSQL.Execute(sStatement, &rsTemp))
			{
				sprintf(sSendBuf, "Execute: Fail on (%s)", sStatement);
				WriteLog(pSockSrvr->icClientID[iClient], sSendBuf);
				giWarningCount++;
				return CMD_ERROR;
			}

			if(rsTemp.RowCount > 0)
			{
				sprintf(sSendBuf, "Statement affected %d rows.", rsTemp.RowCount);
				WriteLog(pSockSrvr->icClientID[iClient], sSendBuf);
			}

			rsTemp.Close();
			continue;
		}
	}

	if(lFetchResult == SQL_NO_DATA_FOUND)
	{
		//Need to delte all transaction from the "SQLExch_Trans" table
		//	where the "SQLExch_Trans.SQLExch_Pending" flag is set to 1.
		//	Any transactions that were added durring the replication process will not
		//	be deleted.
		sprintf(sStatement, "DELETE FROM [%s].[%s].SQLExch_Trans"
			" WHERE TransDB = '%s' AND SQLExch_Pending = 1",
			gsReplicationDB, gsDefaultDBO, gsSQLDatabase);
		CCI.cCustSQL.ExecuteNonQuery(sStatement);

		WriteLog(pSockSrvr->icClientID[iClient], "End of statements.");
		pSockSrvr->SetNextSendData(iClient, "::Complete");
		CCI.rsTrans.Close();

		WriteLog(pSockSrvr->icClientID[iClient], "The process has been completed successfully.");

		return CMD_OK;
	}
	else{
		sprintf(sSendBuf, "SQL Fetch error: %d.", lFetchResult);
		WriteLog(pSockSrvr->icClientID[iClient], sSendBuf);
		giErrorCount++;
		return CMD_ERROR;
	}

	return CMD_ERROR;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
